<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // Add profile_picture column to users table
    $stmt = $pdo->prepare("
        ALTER TABLE users 
        ADD COLUMN profile_picture VARCHAR(255) DEFAULT NULL
    ");
    $stmt->execute();
    
    echo "Successfully added profile_picture column to users table\n";
} catch (PDOException $e) {
    if ($e->getCode() == '42S21') {
        echo "Column profile_picture already exists\n";
    } else {
        echo "Error: " . $e->getMessage() . "\n";
    }
} 